@echo off
setlocal EnableDelayedExpansion

rem Initialize variables
set "latest_war=dataspeeder.war"
set "max_version=0.0.0"

rem Check if the base dataspeeder.war exists and set it as default
if exist "dataspeeder.war" (
    set "latest_war=dataspeeder.war"
    set "max_version=0.0.0"
)

rem Loop through all dataspeeder-*.war files
for %%F in (dataspeeder-*.war) do (
    set "filename=%%F"
    rem Extract version number (e.g., x.y or x.y.z)
    set "version=!filename:dataspeeder-=!"
    set "version=!version:.war=!"

    rem Split version into major, minor, and patch (default patch to 0 if not present)
    for /f "tokens=1,2,3 delims=." %%a in ("!version!") do (
        set "major=%%a"
        set "minor=%%b"
        set "patch=%%c"
        if "!patch!"=="" set "patch=0"
    )

    rem Create a comparable version number (e.g., 002000000 for 2.0.0)
    set "num_version=000!major!!minor!!patch!"
    set "num_version=!num_version:~-9!"

    rem Compare with current max version
    if !num_version! GTR !max_version! (
        set "max_version=!num_version!"
        set "latest_war=%%F"
    )
)

rem Run the latest war file
echo Running !latest_war!...
java -jar "!latest_war!" %*

@if errorlevel 1 pause
endlocal

