#!/bin/bash



# Initialize variables

latest_war="dataspeeder.war"

max_version="0.0.0"



# Check if the base dataspeeder.war exists and set it as default

if [ -f "dataspeeder.war" ]; then

    latest_war="dataspeeder.war"

    max_version="000000000"

fi



# Loop through all dataspeeder-*.war files

for file in dataspeeder-*.war; do

    # Skip if no matching files are found

    [ -f "$file" ] || continue



    # Extract version number (e.g., x.y or x.y.z)

    version="${file#dataspeeder-}"  # Remove 'dataspeeder-' prefix

    version="${version%.war}"       # Remove '.war' suffix



    # Split version into major, minor, and patch (default patch to 0 if not present)

    IFS='.' read -r major minor patch <<< "$version"

    : "${patch:=0}"



    # Create a comparable version number (e.g., 002000000 for 2.0.0)

    num_version=$(printf "%03d%03d%03d" "$major" "$minor" "$patch")



    # Compare with current max version

    if [[ "$num_version" > $max_version ]]; then

        max_version="$num_version"

        latest_war="$file"

    fi

done



# Run the latest war file

echo "Running $latest_war..."

java -jar "$latest_war" "$@"



# Check the exit status of the java command

[ $? -ne 0 ] && read -p "Press Enter to continue..."